# delimit ;
set more 1 ;
set matsize 800 ;
log using shapefinal.log, replace ; 
    


/*   the sorting operations and numbers are:

	Letters - OCR (04), LSM (07), Manual (12), MPBCS (01) DBCS(02)
	Flats   - Manual (11), FSM881(05) FSM1000(06), AFSM100 (39)    */ 

/*  create agg elasticities for shapes and plants */

use regest.dta ;
count ;
sort idnum trend ;

/*  plants with errors in total fhp for letters or flats or total hours for letters or flats */

drop if idnum==76 | (idnum==42 & fy==1999) | (idnum==320 & fy==1999) | (idnum==330 & fy==2000) 
      | idnum==348 | (idnum==87 & fy==1999) | (idnum==124 & fy==1999) | (idnum==142 & fy==1999)
      | (idnum==12 & fy==2004) | (idnum==250 & fy==2000);


/*    delete observations that do not have >=0
        values for fhp for letters and flats or for each type of labor */

drop if fhplet<0 | fhpflt<0 | hrs04<0 | hrs12 <0 | hrs32<0 | hrs11<0 | hrs33<0 | hrs39<0 ;
count ;

/*   group of  plants that always sort flats manually and have incoming and outgoing fhp for flats 
       these will be dropped when we examine flat sorting */

gen manflat=0 ;
replace manflat=1  if idnum==42 | idnum==86 | idnum==121 | idnum==124 | idnum==174 | idnum==188 |
                      idnum==231 | idnum==235 | idnum==240 | idnum==246 | idnum==261 | idnum==266 | 
                      idnum==303 | idnum==311 | idnum==312 ;       


/*  input the estimated output elasticities  */

gen b11in = .526 ;
gen b05in = .723 ;
gen b06in = .651 ;
gen b39in = .791 ;
gen b12in = .869 ;
gen b04in = .703 ;
gen b01in = .076 ;
gen b02in = 1.100 ;

gen b11out = .078 ;
gen b05out = -.017 ;
gen b06out = -.088 ;
gen b39out = .219 ;
gen b12out = .045 ;
gen b04out = .207 ;
gen b01out = .243 ;
gen b02out = .111 ;


/*  generate labor hours shares by sorting operation  */

gen hlet=hrs01 + hrs02 + hrs04 + hrs12 ;
gen hflt=hrs05 + hrs06 + hrs11 + hrs39 ;
gen htot=hlet + hflt ;

gen sh04 = hrs04 / hlet ;
gen sh02 = hrs02 / hlet ;
gen sh01 = hrs01 / hlet ;
gen sh12 = hrs12 / hlet ;

gen sh05 = hrs05 / hflt ;
gen sh06 = hrs06 / hflt ;
gen sh39 = hrs39 / hflt ;
gen sh11 = hrs11 / hflt ;

gen sht06 = hrs06 / htot ;
gen sht02 = hrs02 / htot ;
gen sht01 = hrs01 / htot ;
gen sht12 = hrs12 / htot ;
gen sht05 = hrs05 / htot ;
gen sht11 = hrs11 / htot ;
gen sht04 = hrs04 / htot ;
gen sht39 = hrs39 / htot ;

gen shlet = hlet / htot ;
gen shflt = hflt / htot ;

gen efltin  = sh05*b05in  + sh06*b06in  + sh11*b11in  + sh39*b39in  ;
gen efltout = sh05*b05out + sh06*b06out + sh11*b11out + sh39*b39out  ;
gen eletin  = sh01*b01in  + sh02*b02in  + sh04*b04in  + sh12*b12in  ;
gen eletout = sh01*b01out + sh02*b02out + sh04*b04out + sh12*b12out  ;


gen etotlet = eletin + eletout ;
gen etotflt = efltin + efltout ;
gen etotplant = shlet*etotlet + shflt*etotflt ;

/*  summarize over all years  */

sum sh05 sh06 sh11 sh39 sh01 sh02 sh04 sh12 ;
sum efltin efltout eletin eletout etotlet etotflt etotplant ;

/*  summarize by year and year/qtr */

/*
sort fy qtr;
by fy:  sum efltin efltout eletin eletout etotlet etotflt etotplant ;
by fy qtr: sum efltin efltout eletin eletout etotlet etotflt etotplant ;
*/


sum fhpinlet fhpoutlet fhpinflt fhpoutflt ;

/* sum the shares over all observations  */

gen constant=1 ;
collapse (sum) sh01 sh02 sh04 sh05 sh06 sh12 sh11 sh39
               sht01 sht02 sht04 sht05 sht06 sht12
               sht11 sht39 shlet shflt 
          (mean) fhpinlet fhpoutlet fhpinflt fhpoutflt
                 eletin eletout efltin efltout
	         (count) constant ; 




/*  construct variances for the average values over all observations - to construct the se for
      some other subset of the observations just drop all other observations before the collapse command */

/*   squared the summed shares  */

gen sh062 = sh06*sh06 ;
gen sh022 = sh02*sh02 ;
gen sh012 = sh01*sh01 ;
gen sh112 = sh11*sh11 ;
gen sh052 = sh05*sh05 ;
gen sh122 = sh12*sh12 ;
gen sh042 = sh04*sh04 ;
gen sh392 = sh39*sh39 ;

gen sht062 = sht06*sht06 ;
gen sht022 = sht02*sht02 ;
gen sht012 = sht01*sht01 ;
gen sht112 = sht11*sht11 ;
gen sht052 = sht05*sht05 ;
gen sht122 = sht12*sht12 ;
gen sht042 = sht04*sht04 ;
gen sht392 = sht39*sht39 ;

gen shlet2 = shlet*shlet ;
gen shflt2 = shflt*shflt ;

/*  input the standard errors  */

gen sb11in = .140 ;
gen sb05in = .081 ;
gen sb06in = .206 ;
gen sb39in = .085 ;
gen sb12in = .091 ;
gen sb04in = .225 ;
gen sb01in = .514 ;
gen sb02in = .130 ;

gen sb11out = .073 ;
gen sb05out = .070 ;
gen sb06out = .085 ;
gen sb39out = .027 ;
gen sb12out = .020 ;
gen sb04out = .046 ;
gen sb01out = .082 ;
gen sb02out = .028 ;


gen sfltin = sqrt( (1/constant^2)*( (sb05in^2)*sh052 + (sb06in^2)*sh062 +
                                    (sb11in^2)*sh112  + (sb39in^2)*sh392 )) ;
gen sfltout =sqrt( (1/constant^2)*( (sb05out^2)*sh052 + (sb06out^2)*sh062 + (sb11out^2)*sh112  + (sb39out^2)*sh392 ));
gen sletin = sqrt( (1/constant^2)*( (sb01in^2)*sh012 + (sb02in^2)*sh022+ (sb12in^2)*sh122 + (sb04in^2)*sh042 )) ;
gen sletout =sqrt( (1/constant^2)*( (sb01out^2)*sh012 + (sb02out^2)*sh022 + (sb12out^2)*sh122  + (sb04out^2)*sh042 ));

gen se12 = sqrt(sb12in^2 + sb12out^2) ;
gen se05 = sqrt(sb05in^2 + sb05out^2) ;
gen se06 = sqrt(sb06in^2 + sb06out^2) ;
gen se39 = sqrt(sb39in^2 + sb39out^2) ;
gen se11 = sqrt(sb11in^2 + sb11out^2) ;
gen se04 = sqrt(sb04in^2 + sb04out^2) ;
gen se01 = sqrt(sb01in^2 + sb01out^2) ;
gen se02 = sqrt(sb02in^2 + sb02out^2) ;


gen slet =sqrt( (1/constant^2)*( (se01^2)*sh012 + (se02^2)*sh022 + (se12^2)*sh122  + (se04^2)*sh042 ));
gen sflt =sqrt( (1/constant^2)*( (se05^2)*sh052 + (se06^2)*sh062 + (se11^2)*sh112  + (se39^2)*sh392 ));
gen splant = sqrt( (1/constant^2)*( (se06^2)*sht062 + (se01^2)*sht012 + (se02^2)*sht022 + (se12^2)*sht122 + 
                                    (se11^2)*sht112 + (se05^2)*sht052 + (se04^2)*sht042 + (se39^2)*sht392 ) ) ; 
    

list sfltin sfltout sflt sletin sletout slet splant ;


