# delimit ;
set more 1 ;
set matsize 800 ;
log using d:\postal05\bozzo\estimate\aggraph.log, replace ; 
    

/*   construct time series graphs of hours and fhp  */

use regest.dta ;

/*  use a group of 294 plants with all years data that is used in estimation  */ 

drop if idnum==76 | idnum==42 | idnum==320 | idnum==330 | idnum==348 | idnum==87 | idnum==124 | idnum==142 
      | idnum==12 | idnum==250 ;


sort fy qtr ;
 
collapse (sum) hrs39 hrs06 hrs05 hrs33 hrs01 hrs02 hrs32 hrs04 hrs11 hrs12 hrs07
               tpf39 tpf06 tpf05 tpf33 tpf01 tpf02 tpf32 tpf04 tpf11 tpf12 tpf07
               fhplet fhpflt fhpinlet fhpoutlet fhpinflt fhpoutflt hrslet hrsflt
         (mean) trend, by(fy qtr) ;
tab qtr, gen(dq) ;
tab fy, gen(dy) ;



gen prodlet=fhplet/hrslet ;
gen prodflt=fhpflt/hrsflt ;
gen tpflet = tpf32 + tpf04 + tpf07 + tpf12 ;
gen tpfflt = tpf33 + tpf39 + tpf11 ;


label var prodlet "FHP/Hour Letters" ;
label var prodflt "FHP/Hour Flats" ;
label var fhplet "FHP Letters - Total" ;
label var fhpflt "FHP Flats - Total" ;
label var fhpinlet "FHP Letters - Incoming" ;
label var fhpoutlet "FHP Letters - Outgoing" ;
label var fhpinflt "FHP Flats - Incoming" ;
label var fhpoutflt "FHP Flats - Outgoing" ;
label var hrslet "Hours Letters - Total" ;
label var hrsflt "Hours Flats - Total" ;
label var hrs39 "Hours AFSM100" ;
label var hrs06 "Hours FSM1000" ;
label var hrs05 "Hours FSM881" ;
label var hrs01 "Hours MPBCS" ;
label var hrs02 "Hours DBCS" ;
label var hrs32 "Hours All BCS" ;
label var hrs04 "Hours OCR" ;
label var hrs11 "Hours Manual Flats" ;
label var hrs12 "Hours Manual Letters" ;
label var hrs07 "Hours LSM" ;
label var hrs33 "Hours All FSM" ;

label var trend "quarters starting in 1999:1" ;


twoway (connect hrs39 trend, sort msymbol(O)) (connect hrs06 trend, sort msymbol(T))
       (connect hrs05 trend, sort msymbol(D)) (connect hrs11 trend, sort msymbol(o)),
       l1(thousands of manhours) xlabel(1 5 9 13 17 21) subtitle(Manhours in Flat Sorting Operations) 
       scheme(s1color) saving(hrsflt2.gph, replace);
 graph export hrsflt.wmf, replace ; 

twoway (connect hrs04 trend, sort msymbol(O)) (connect hrs01 trend, sort msymbol(T))
       (connect hrs02 trend, sort msymbol(D)) (connect hrs12 trend, sort msymbol(o)),
       l1(thousands of manhours) xlabel(1 5 9 13 17 21) subtitle(Manhours in Letter Sorting Operations) 
       scheme(s1color) saving(hrslet2.gph, replace);
 graph export hrslet.wmf, replace ; 

twoway (connect fhpinlet trend, sort msymbol(O)) (connect fhpoutlet trend, sort msymbol(T)),
       l1(millions of pieces) xlabel(1 5 9 13 17 21) subtitle(FHP in Letter Sorting Operations) 
       scheme(s1color) saving(fhplet2.gph, replace) ;
 graph export fhplet.wmf, replace ; 

twoway (connect fhpinflt trend, sort msymbol(O)) (connect fhpoutflt trend, sort msymbol(T)),
       l1(millions of pieces) xlabel(1 5 9 13 17 21) subtitle(FHP in Flat Sorting Operations) 
       scheme(s1color) saving(fhpflt2.gph, replace) ;
 graph export fhpflt.wmf, replace ; 


/*  remove the mean  */

egen mhlet = mean(hrslet) ;
gen dhrslet=hrslet-mhlet ;

egen mflet = mean(fhplet) ;
gen dfhplet=fhplet-mflet ;

egen mhflt = mean(hrsflt) ;
gen dhrsflt=hrsflt-mhflt ;

egen mfflt = mean(fhpflt) ;
gen dfhpflt=fhpflt-mfflt ;

label var dhrslet "Total Hours" ;
label var dhrsflt "Total Hours" ;
label var dfhplet "Total FHP" ;
label var dfhpflt "Total FHP" ;

/*  remove year effects   */

regress hrslet  dy2-dy6 ;
predict hlety, resid ;

regress fhplet  dy2-dy6  ;
predict flety, resid ;

regress hrsflt  dy2-dy6 ;
predict hflty, resid ;

regress fhpflt  dy2-dy6 ;
predict fflty, resid ;

label var hlety "Total Hours" ;
label var hflty "Total Hours" ;
label var flety "Total FHP" ;
label var fflty "Total FHP" ;

/*   remove year and quarterly effects   */

regress hrslet dq2-dq4 dy2-dy6;
predict hletyq, resid ;

regress fhplet dq2-dq4 dy2-dy6;
predict fletyq, resid ;

regress hrsflt dq2-dq4 dy2-dy6;
predict hfltyq, resid ;

regress fhpflt dq2-dq4 dy2-dy6;
predict ffltyq, resid ;

label var hletyq "Total Hours" ;
label var hfltyq "Total Hours" ;
label var fletyq "Total FHP" ;
label var ffltyq "Total FHP" ;


twoway (connect dhrsflt trend, sort msymbol(O)) (connect dfhpflt trend, sort msymbol(T)),
       xlabel(1 5 9 13 17 21) subtitle(Deviations from the Overall Mean) 
       scheme(s1color) saving(flatmeandev2.gph, replace) ;
 graph export flatmeandev.wmf, replace ; 

twoway (connect hflty trend, sort msymbol(O)) (connect fflty trend, sort msymbol(T)),
       xlabel(1 5 9 13 17 21) subtitle(Deviations from the Year Means)  
       scheme(s1color) saving(flatyeardev2.gph, replace) ;
 graph export flatyeardev.wmf, replace ; 

twoway (connect hfltyq trend, sort msymbol(O)) (connect ffltyq trend, sort msymbol(T)),
       xlabel(1 5 9 13 17 21) subtitle(Deviations from the Year and Quarter Means)   
       scheme(s1color) saving(flatyqdev2.gph, replace) ;
 graph export flatyqdev.wmf, replace ; 


/*  compare trends in fhp in and out  */

gen shinlet = fhpinlet/(fhpinlet+ fhpoutlet) ;
gen shoutlet = fhpoutlet/(fhpinlet + fhpoutlet) ;
gen shinflt = fhpinflt/(fhpinflt+ fhpoutflt) ;
gen shoutflt = fhpoutflt/(fhpinflt + fhpoutflt) ;

list trend fhplet fhpinlet fhpoutlet shinlet shoutlet ;
list trend fhpflt fhpinflt fhpoutflt shinflt shoutflt ;


