# delimit ;
set more 1 ;
set matsize 800 ;
log using finalestq.log, replace ; 
display "$S_DATE" ;    
display "$S_TIME" ;     


/*  include quarterly dummies in all labor demand equations   */


/*  set up data for labor demand estimation - input data has 301 plants and 24 time obs (quarters 99-04) */
/*   the sorting operations and numbers are:

	Letters - OCR (04), LSM (07), Manual (12), BCS (32 = 01 + 02)
	Flats   - Manual (11), FSM (33 = 05 + 06), AFSM100 (39)
	Priority - Manual (14) 
	Parcels - SPBS (34 = 09 + 10), Manual (13)  */ 


use regest.dta ;
count ;
sort idnum trend ;
tsset idnum trend ;

/*  plants with errors in total fhp for letters or flats or total hours for letters or flats */

drop if idnum==76 | (idnum==42 & fy==1999) | (idnum==320 & fy==1999) | (idnum==330 & fy==2000) 
      | idnum==348 | (idnum==87 & fy==1999) | (idnum==124 & fy==1999) | (idnum==142 & fy==1999)
      | (idnum==12 & fy==2004) | (idnum==250 & fy==2000);


/*    delete observations that do not have >=0
        values for fhp for letters and flats or for each type of labor */

drop if fhplet<0 | fhpflt<0 | hrs04<0 | hrs12 <0 | hrs32<0 | hrs11<0 | hrs33<0 | hrs39<0 ;
count ;

/*   group of  plants that always sort flats manually and have incoming and outgoing fhp for flats 
       these will be dropped when we examine flat sorting */

gen manflat=0 ;
replace manflat=1  if idnum==42 | idnum==86 | idnum==121 | idnum==124 | idnum==174 | idnum==188 |
                      idnum==231 | idnum==235 | idnum==240 | idnum==246 | idnum==261 | idnum==266 | 
                      idnum==303 | idnum==311 | idnum==312 ;       



/*  selection criteria  */

gen oklet=1 if okbcs==1 & okocr==1 ;
gen okflt=1 if okfsm==1 & okafsm==1 ;
gen ok01 =1 if okbcs==1 & okocr==1 & neard01==0 ;
gen ok05 =1 if okfsm==1 & okafsm==1 & neard05==0 & fy~=2004 ;
gen ok39 =1 if okfsm==1 & okafsm==1  & new39==0 & fy~=2001 ;
sort idnum ;
egen nlet=count(oklet), by(idnum) ;
egen nflt=count(okflt), by(idnum) ;
egen nok01=count(ok01), by(idnum) ;
egen nok05=count(ok05), by(idnum) ;
egen nok39=count(ok39), by(idnum) ;

/*  identify plants that will have more than 2 observations in the regression */
gen includelet=1 if nlet>2 ;
gen includeflt=1 if nflt>2 ;
gen include01=1 if nok01>2 ;
gen include05=1 if nok05>2 ;
gen include39=1 if nok39>2 ;



/*****************************************/
/*****************************************/
/*              LETTERS                  */
/*****************************************/
/*****************************************/

/***********************************/
/*   letters total                 */
/***********************************/





xtivreg lhlet dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhplet =lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum) ;
xtivreg lhlet dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhpinlet lfhpoutlet=lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum)  ;


/***********************************/
/*   letters manual 12             */
/***********************************/



xtivreg lhrs12 dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhplet =lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum) ;
xtivreg lhrs12 dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhpinlet lfhpoutlet=lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum)  ;

/***********************************/
/*   letters bcs 32                */
/***********************************/




xtivreg lhrs32 dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhplet =lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum) ;
xtivreg lhrs32 dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhpinlet lfhpoutlet=lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum)  ;

/***********************************/
/*   letters mpbcs 01              */
/***********************************/



xtivreg lhrs01 dq2-dq4 dy2-dy6   tech02 qimpbcs qidbcs qiocr rwlet (lfhplet =lfhpinflt lfhpoutflt) if oklet==1 & includelet==1 & neard01==0, fe i(idnum) ;
xtivreg lhrs01 dq2-dq4 dy2-dy6   tech02 qimpbcs qidbcs qiocr rwlet (lfhpinlet lfhpoutlet=lfhpinflt lfhpoutflt) if oklet==1 & includelet==1 & neard01==0, fe i(idnum)  ;


/***********************************/
/*   letters dbcs 02              */
/***********************************/




xtivreg lhrs02 dq2-dq4 dy2-dy6 tech01   qimpbcs qidbcs qiocr rwlet (lfhplet =lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum) ;
xtivreg lhrs02 dq2-dq4 dy2-dy6 tech01   qimpbcs qidbcs qiocr rwlet (lfhpinlet lfhpoutlet=lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum)  ;

/***********************************/
/*   letters ocr 04                */
/***********************************/




xtivreg lhrs04 dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhplet =lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum) ;
xtivreg lhrs04 dq2-dq4 dy2-dy6 tech01 tech02 qimpbcs qidbcs qiocr rwlet (lfhpinlet lfhpoutlet=lfhpinflt lfhpoutflt) if oklet==1 & includelet==1, fe i(idnum)  ;



/*****************************************/
/*****************************************/
/*              FLATS                    */
/*****************************************/
/*****************************************/

/*  drop plants that always sort flats manually  */
drop if manflat==1 ;

/****************************************/
/*   flats  total                       */
/****************************************/



xtivreg lhflt dq2-dq4 dy2-dy6 tech05 tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpflt =lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum) ;
xtivreg lhflt dq2-dq4 dy2-dy6 tech05 tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpinflt lfhpoutflt=lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum)  ;

/****************************************/
/*   flats  manual 11                   */
/****************************************/



xtivreg lhrs11 dq2-dq4 dy2-dy6 tech05 tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpflt =lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum) ;
xtivreg lhrs11 dq2-dq4 dy2-dy6 tech05 tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpinflt lfhpoutflt=lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum)  ;




/****************************************/
/*   flats  fsm 33                      */
/****************************************/



xtivreg lhrs33 dq2-dq4 dy2-dy6 tech05 tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpflt =lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum) ;
xtivreg lhrs33 dq2-dq4 dy2-dy6 tech05 tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpinflt lfhpoutflt=lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum)  ;

/****************************************/
/*   flats  fsm881 (05)                 */
/****************************************/


xtivreg lhrs05 dq2-dq4 dy2-dy6   tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpflt =lfhpinlet lfhpoutlet) if okflt==1 & include05==1 & neard05==0 & fy~=2004, fe i(idnum) ;
xtivreg lhrs05 dq2-dq4 dy2-dy6   tech06 tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpinflt lfhpoutflt=lfhpinlet lfhpoutlet) if okflt==1 & include05==1 & neard05==0 & fy~=2004, fe i(idnum)  ;



/****************************************/
/*   flats  fsm1000 (06)                */
/****************************************/


xtivreg lhrs06 dq2-dq4 dy2-dy6 tech05   tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpflt =lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum) ;
xtivreg lhrs06 dq2-dq4 dy2-dy6 tech05   tech39 qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpinflt lfhpoutflt=lfhpinlet lfhpoutlet) if okflt==1 & includeflt==1, fe i(idnum)  ;


/****************************************/
/*   flats  afsm100 (39)                */
/****************************************/


xtivreg lhrs39 dq2-dq4 dy2-dy6 tech05 tech06   qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpflt =lfhpinlet lfhpoutlet) if okflt==1 & include39==1 & new39==0 & fy~=2001, fe i(idnum) ;
xtivreg lhrs39 dq2-dq4 dy2-dy6 tech05 tech06   qifsm881 qifsm1000 qiafsm100 rwfsm (lfhpinflt lfhpoutflt=lfhpinlet lfhpoutlet) if okflt==1 & include39==1 & new39==0 & fy~=2001, fe i(idnum)  ;



